# Kassenbuch - Anleitung für echte Daten

## 🎯 Übersicht

Das Kassenbuch ist vollständig für den täglichen Gebrauch mit echten Daten ausgelegt. Es unterstützt alle notwendigen Funktionen für eine professionelle Notariatsbuchhaltung.

## 📊 Standardwerte vs. Echte Daten

### Beispieldaten (nur für Demo)
- **4 Beispiel-Einträge** werden beim ersten Start geladen
- Enthalten fiktive Daten zur Demonstration der Funktionen
- **Nicht für den Produktiveinsatz gedacht**

### Echte Daten (für täglichen Gebrauch)
- **Vollständig unterstützt** für alle Notariatsgeschäfte
- **Professionelle Datenstruktur** mit allen notwendigen Feldern
- **Audit-Logging** für Nachverfolgbarkeit
- **Export-Funktionen** für DATEV und Buchhaltung

## 🚀 Erste Schritte mit echten Daten

### 1. Beispieldaten löschen
1. Öffnen Sie das Kassenbuch in der Anwendung
2. Klicken Sie auf den **"Beispieldaten löschen"** Button (orange)
3. Bestätigen Sie die Löschung
4. Das Kassenbuch ist jetzt bereit für echte Daten

### 2. Ersten echten Eintrag erstellen
1. Klicken Sie auf **"Neuer Eintrag"**
2. Füllen Sie die Pflichtfelder aus:
   - **Datum:** Aktuelles Datum
   - **Typ:** Einnahme oder Ausgabe
   - **Kategorie:** Wählen Sie die passende Kategorie
   - **Beschreibung:** Kurze Beschreibung der Transaktion
   - **Betrag:** Euro-Betrag (z.B. 250.00)
3. Optional: Füllen Sie weitere Felder aus
4. Klicken Sie auf **"Eintrag hinzufügen"**

## 📋 Unterstützte Datentypen

### Einnahmen (Typ: income)
- **Notariatsgebühren:** Beurkundungen, Beglaubigungen
- **Unterschriftsbeglaubigung:** Vollmachten, Unterschriften
- **Testamentserrichtung:** Testamente, Erbverträge
- **Grundbuchanträge:** Grundbuchänderungen
- **Sonstige Einnahmen:** Beratungen, Gutachten

### Ausgaben (Typ: expense)
- **Büromaterial:** Papier, Tinte, Bürobedarf
- **Software:** Programme, Lizenzen
- **Fortbildung:** Seminare, Schulungen
- **Versicherungen:** Haftpflicht, Büroversicherung
- **Sonstige Ausgaben:** Miete, Nebenkosten

### Zahlungsmethoden
- **Bargeld:** Für kleine Beträge
- **Überweisung:** Banküberweisungen
- **Kreditkarte:** Kartenzahlungen

## 🔍 Erweiterte Funktionen

### Pflichtfelder
- **Datum:** Transaktionsdatum
- **Typ:** Einnahme oder Ausgabe
- **Kategorie:** Geschäftskategorie
- **Beschreibung:** Transaktionsbeschreibung
- **Betrag:** Euro-Betrag

### Optionale Felder
- **Mandant-ID:** Kundenreferenz (z.B. CL001)
- **Aktenzeichen:** Fallnummer (z.B. KV-2025-001)
- **Belegnummer:** Quittungsnummer (z.B. R-2025-001)
- **Notizen:** Zusätzliche Informationen

## 📈 Statistiken und Auswertungen

Das System berechnet automatisch:
- **Gesamteinnahmen:** Summe aller Einnahmen
- **Gesamtausgaben:** Summe aller Ausgaben
- **Nettogewinn:** Einnahmen minus Ausgaben
- **Monatliche Werte:** Aktueller Monat
- **Trends:** Entwicklung über Zeit

## 🔒 Sicherheit und Audit

### Audit-Logging
- **Automatische Protokollierung** aller Änderungen
- **Wer hat was wann geändert**
- **Vorher-Nachher-Werte** bei Änderungen
- **Export des Audit-Logs** möglich

### Monatsabschlüsse
- **Monatliche Abschlüsse** mit Sperrung
- **Export der Monatsdaten**
- **Nachverfolgbarkeit** aller Transaktionen

## 📤 Export-Funktionen

### Unterstützte Formate
- **CSV:** Für Excel-Import
- **Excel (XLSX):** Direkte Excel-Dateien
- **PDF:** Druckbare Berichte
- **XML:** Für Systemintegration
- **DATEV:** Für Buchhaltungssoftware
- **Audit-Log:** Protokoll aller Änderungen

### Export-Schritte
1. Klicken Sie auf **"Export"**
2. Wählen Sie das gewünschte Format
3. Datei wird automatisch heruntergeladen
4. Datei kann in Buchhaltungssoftware importiert werden

## 💡 Tipps für den täglichen Gebrauch

### Best Practices
1. **Regelmäßige Einträge:** Erstellen Sie Einträge zeitnah
2. **Konsistente Kategorien:** Verwenden Sie einheitliche Kategorien
3. **Detaillierte Beschreibungen:** Für bessere Nachverfolgbarkeit
4. **Monatsabschlüsse:** Regelmäßige Abschlüsse für Übersicht
5. **Backup-Exporte:** Regelmäßige Exporte als Backup

### Datenschutz
- **Lokale Speicherung:** Daten bleiben auf Ihrem Computer
- **Keine Cloud-Synchronisation:** Maximale Datenschutz
- **Export-Backups:** Regelmäßige Sicherungskopien

## ⚠️ Wichtige Hinweise

### Datenpersistierung
- **localStorage:** Daten werden im Browser gespeichert
- **Browser-spezifisch:** Daten sind nur im verwendeten Browser verfügbar
- **Backup empfohlen:** Regelmäßige Exporte als Sicherung

### Rechtliche Anforderungen
- **Buchhaltungspflicht:** Einhaltung der gesetzlichen Vorgaben
- **Aufbewahrungsfristen:** 10 Jahre für Geschäftsunterlagen
- **DATEV-Konformität:** Export-Funktionen für DATEV-Import

## 🆘 Support

Bei Fragen oder Problemen:
1. **Browser-Konsole:** Öffnen Sie F12 für Debug-Informationen
2. **Export-Backup:** Erstellen Sie regelmäßige Backups
3. **Dokumentation:** Diese Anleitung als Referenz

---

**Das Kassenbuch ist bereit für den professionellen Einsatz mit echten Daten!** 🎉 